/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import sun.net.ExtendedSocketOptions;
import sun.net.ResourceManager;
import sun.security.action.GetPropertyAction;

abstract class AbstractPlainDatagramSocketImpl
extends DatagramSocketImpl {
    int timeout = 0;
    boolean connected = false;
    private int trafficClass = 0;
    protected InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private static final String os = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static final boolean connectDisabled = os.contains("OS X");
    static final ExtendedSocketOptions extendedOptions;
    private static final Set<SocketOption<?>> datagramSocketOptions;
    private static final Set<SocketOption<?>> multicastSocketOptions;

    AbstractPlainDatagramSocketImpl() {
    }

    @Override
    protected synchronized void create() throws SocketException {
        ResourceManager.beforeUdpCreate();
        this.fd = new FileDescriptor();
        try {
            this.datagramSocketCreate();
        }
        catch (SocketException socketException) {
            ResourceManager.afterUdpClose();
            this.fd = null;
            throw socketException;
        }
    }

    @Override
    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        this.bind0(n, inetAddress);
    }

    protected abstract void bind0(int var1, InetAddress var2) throws SocketException;

    @Override
    protected abstract void send(DatagramPacket var1) throws IOException;

    @Override
    protected void connect(InetAddress inetAddress, int n) throws SocketException {
        this.connect0(inetAddress, n);
        this.connectedAddress = inetAddress;
        this.connectedPort = n;
        this.connected = true;
    }

    @Override
    protected void disconnect() {
        this.disconnect0(this.connectedAddress.holder().getFamily());
        this.connected = false;
        this.connectedAddress = null;
        this.connectedPort = -1;
    }

    @Override
    protected abstract int peek(InetAddress var1) throws IOException;

    @Override
    protected abstract int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        this.receive0(datagramPacket);
    }

    protected abstract void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected abstract void setTimeToLive(int var1) throws IOException;

    @Override
    protected abstract int getTimeToLive() throws IOException;

    @Override
    @Deprecated
    protected abstract void setTTL(byte var1) throws IOException;

    @Override
    @Deprecated
    protected abstract byte getTTL() throws IOException;

    @Override
    protected void join(InetAddress inetAddress) throws IOException {
        this.join(inetAddress, null);
    }

    @Override
    protected void leave(InetAddress inetAddress) throws IOException {
        this.leave(inetAddress, null);
    }

    @Override
    protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.join(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    protected abstract void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.leave(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    protected abstract void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void close() {
        if (this.fd != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
        }
    }

    protected boolean isClosed() {
        return this.fd == null;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public void setOption(int n, Object object) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (n) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 4: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 32: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_BROADCAST");
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (object != null && object instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            case 31: {
                if (object != null && object instanceof NetworkInterface) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF2");
            }
            case 18: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for IP_MULTICAST_LOOP");
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        this.socketSetOption(n, object);
    }

    @Override
    public Object getOption(int n) throws SocketException {
        Object object;
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (n) {
            case 4102: {
                object = new Integer(this.timeout);
                break;
            }
            case 3: {
                object = this.socketGetOption(n);
                if ((Integer)object != -1) break;
                object = new Integer(this.trafficClass);
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 31: 
            case 32: 
            case 4097: 
            case 4098: {
                object = this.socketGetOption(n);
                break;
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        return object;
    }

    private static Set<SocketOption<?>> datagramSocketOptions() {
        HashSet hashSet = new HashSet();
        hashSet.add(StandardSocketOptions.SO_SNDBUF);
        hashSet.add(StandardSocketOptions.SO_RCVBUF);
        hashSet.add(StandardSocketOptions.SO_REUSEADDR);
        hashSet.add(StandardSocketOptions.IP_TOS);
        hashSet.addAll(ExtendedSocketOptions.datagramSocketOptions());
        return Collections.unmodifiableSet(hashSet);
    }

    private static Set<SocketOption<?>> multicastSocketOptions() {
        HashSet hashSet = new HashSet();
        hashSet.add(StandardSocketOptions.SO_SNDBUF);
        hashSet.add(StandardSocketOptions.SO_RCVBUF);
        hashSet.add(StandardSocketOptions.SO_REUSEADDR);
        hashSet.add(StandardSocketOptions.IP_TOS);
        hashSet.add(StandardSocketOptions.IP_MULTICAST_IF);
        hashSet.add(StandardSocketOptions.IP_MULTICAST_TTL);
        hashSet.add(StandardSocketOptions.IP_MULTICAST_LOOP);
        hashSet.addAll(ExtendedSocketOptions.datagramSocketOptions());
        return Collections.unmodifiableSet(hashSet);
    }

    private Set<SocketOption<?>> supportedOptions() {
        if (this.getDatagramSocket() instanceof MulticastSocket) {
            return multicastSocketOptions;
        }
        return datagramSocketOptions;
    }

    @Override
    protected <T> void setOption(SocketOption<T> socketOption, T t) throws IOException {
        Objects.requireNonNull(socketOption);
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        if (!socketOption.type().isInstance(t)) {
            throw new IllegalArgumentException("Invalid value '" + t + "'");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        if (socketOption == StandardSocketOptions.SO_SNDBUF) {
            if ((Integer)t < 0) {
                throw new IllegalArgumentException("Invalid send buffer size:" + t);
            }
            this.setOption(4097, t);
        } else if (socketOption == StandardSocketOptions.SO_RCVBUF) {
            if ((Integer)t < 0) {
                throw new IllegalArgumentException("Invalid recv buffer size:" + t);
            }
            this.setOption(4098, t);
        } else if (socketOption == StandardSocketOptions.SO_REUSEADDR) {
            this.setOption(4, t);
        } else if (socketOption == StandardSocketOptions.IP_TOS) {
            int n = (Integer)t;
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("Invalid IP_TOS value: " + t);
            }
            this.setOption(3, t);
        } else if (socketOption == StandardSocketOptions.IP_MULTICAST_IF) {
            this.setOption(31, t);
        } else if (socketOption == StandardSocketOptions.IP_MULTICAST_TTL) {
            int n = (Integer)t;
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("Invalid TTL/hop value: " + t);
            }
            this.setTimeToLive((Integer)t);
        } else if (socketOption == StandardSocketOptions.IP_MULTICAST_LOOP) {
            this.setOption(18, t);
        } else if (extendedOptions.isOptionSupported(socketOption)) {
            extendedOptions.setOption(this.fd, socketOption, t);
        } else {
            throw new AssertionError((Object)("unknown option :" + socketOption));
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> socketOption) throws IOException {
        Objects.requireNonNull(socketOption);
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        if (socketOption == StandardSocketOptions.SO_SNDBUF) {
            return (T)this.getOption(4097);
        }
        if (socketOption == StandardSocketOptions.SO_RCVBUF) {
            return (T)this.getOption(4098);
        }
        if (socketOption == StandardSocketOptions.SO_REUSEADDR) {
            return (T)this.getOption(4);
        }
        if (socketOption == StandardSocketOptions.IP_TOS) {
            return (T)this.getOption(3);
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_IF) {
            return (T)this.getOption(31);
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_TTL) {
            return (T)Integer.valueOf(this.getTimeToLive());
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_LOOP) {
            return (T)this.getOption(18);
        }
        if (extendedOptions.isOptionSupported(socketOption)) {
            return (T)extendedOptions.getOption(this.fd, socketOption);
        }
        throw new AssertionError((Object)("unknown option: " + socketOption));
    }

    protected abstract void datagramSocketCreate() throws SocketException;

    protected abstract void datagramSocketClose();

    protected abstract void socketSetOption(int var1, Object var2) throws SocketException;

    protected abstract Object socketGetOption(int var1) throws SocketException;

    protected abstract void connect0(InetAddress var1, int var2) throws SocketException;

    protected abstract void disconnect0(int var1);

    protected boolean nativeConnectDisabled() {
        return connectDisabled;
    }

    @Override
    abstract int dataAvailable();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                return null;
            }
        });
        extendedOptions = ExtendedSocketOptions.getInstance();
        datagramSocketOptions = AbstractPlainDatagramSocketImpl.datagramSocketOptions();
        multicastSocketOptions = AbstractPlainDatagramSocketImpl.multicastSocketOptions();
    }
}

